package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.LudoMatchAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.FragmentFFOngoingBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.MatchResponse;
import app.firezone.synk.network.model.Match_Model;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;


public class FFOngoingFragment extends Fragment {

    FragmentFFOngoingBinding binding;
    Dialog dialog;
    ArrayList<Match_Model> mlist = new ArrayList<>();
    LudoMatchAdapter myAdapter;
    String gamename;

    private Handler handler = new Handler();
    private Runnable autoRefreshRunnable;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        binding = FragmentFFOngoingBinding.inflate(inflater, container, false);
        View root = binding.getRoot();

        if (getArguments() != null) {
            gamename = getArguments().getString("gamename");
        }

        setupDialog();
        setupRecycler();
        fetchMatchData();

        binding.swipeRefresh.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                fetchMatchData();
            }
        });

        return root;
    }

    private void setupDialog() {
        dialog = new Dialog(getContext());
        dialog.setContentView(R.layout.loading_dialog);
        if (dialog.getWindow() != null)
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.setCancelable(false);
        dialog.show();
    }

    private void setupRecycler() {
        binding.ffMatchRecy.setLayoutManager(new LinearLayoutManager(getContext()));
        myAdapter = new LudoMatchAdapter(getContext(), new ArrayList<>());
        binding.ffMatchRecy.setAdapter(myAdapter);
    }

    private void fetchMatchData() {

        if (!binding.swipeRefresh.isRefreshing()) {
            dialog.show();
        }

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<MatchResponse> call = myApi.getMatchDataByGameName(gamename);

        call.enqueue(new Callback<MatchResponse>() {
            @Override
            public void onResponse(Call<MatchResponse> call, Response<MatchResponse> response) {
                if (!isAdded()) return;

                if (dialog.isShowing()) dialog.dismiss();
                mlist.clear();

                binding.swipeRefresh.setRefreshing(false); // Stop swipe animation

                if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                    List<Match_Model> matches = response.body().getMatches();

                    if (matches != null && !matches.isEmpty()) {
                        for (Match_Model match : matches) {
                            if ("Ongoing".equalsIgnoreCase(match.getMatchstatus())) {
                                mlist.add(match);
                            }
                        }
                        enrichMatchesWithJoinData(mlist);
                    } else {
                        myAdapter.updateList(new ArrayList<>());
                      //  Toast.makeText(getContext(), "No Ongoing matches found.", Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(getContext(), "Failed to load data.", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<MatchResponse> call, Throwable throwable) {
                if (!isAdded()) return;
                if (dialog.isShowing()) dialog.dismiss();
                binding.swipeRefresh.setRefreshing(false); // Stop swipe animation
                Toast.makeText(getContext(), "Network error: " + throwable.getMessage(), Toast.LENGTH_LONG).show();
            }
        });
    }

    private void enrichMatchesWithJoinData(ArrayList<Match_Model> matchList) {
        long userId = SharedPrefManager.getInstance(getContext()).getUserId();
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        ArrayList<Match_Model> enrichedList = new ArrayList<>();
        AtomicInteger completedCount = new AtomicInteger(0);
        int totalMatches = matchList.size();

        for (Match_Model originalMatch : matchList) {
            Match_Model match = new Match_Model(); // create fresh copy
            match.copyFrom(originalMatch);

            AtomicInteger perMatchCounter = new AtomicInteger(0);

            // Default values
            match.setMatchCode("not_joined");
            match.setTotalPlayerJoined("0");
            match.setJoinedCount(0);
            match.setUserJoined(false);

            // API 1: Check if user joined
            myApi.checkIfUserJoined(userId, match.getId()).enqueue(new Callback<CheckJoinedResponse>() {
                @Override
                public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                    if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                        match.setMatchCode("Joined");
                        match.setUserJoined(true); // ✅ set user joined true
                    }

                    if (perMatchCounter.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        if (completedCount.incrementAndGet() == totalMatches) {
                            myAdapter.updateList(enrichedList);
                        }
                    }
                }

                @Override
                public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                    if (perMatchCounter.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        if (completedCount.incrementAndGet() == totalMatches) {
                            myAdapter.updateList(enrichedList);
                        }
                    }
                }
            });

            // API 2: Fetch joined player count
            myApi.fetchMatchJoinedUsers(match.getId()).enqueue(new Callback<ArrayList<Joined_Match_Model>>() {
                @Override
                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        int count = response.body().size();
                        match.setTotalPlayerJoined(String.valueOf(count));  // Optional if not used elsewhere
                        match.setJoinedCount(count); // ✅ Needed for adapter
                    }

                    if (perMatchCounter.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        if (completedCount.incrementAndGet() == totalMatches) {
                            myAdapter.updateList(enrichedList);
                        }
                    }
                }

                @Override
                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                    if (perMatchCounter.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        if (completedCount.incrementAndGet() == totalMatches) {
                            myAdapter.updateList(enrichedList);
                        }
                    }
                }
            });
        }
    }

}
